package gov.va.vamf.scheduling.direct.resource;


import com.agilex.healthcare.veteranappointment.dataservice.DisabledFeatureService;
import com.agilex.healthcare.veteranappointment.domain.DisabledFeatures;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Component
@Path("/disabled-features")
@Scope("request")
public class DisabledFeatureResource {

    @Resource
    DisabledFeatureService disabledFeatureService;

    @GET
    @Produces({ "application/json" })
    @Path("/")
    public DisabledFeatures getDisabledFeatures() {
        return disabledFeatureService.getDisabledFeatures();
    }
}
